#ifndef _ARRAY_H
#define _ARRAY_H
#include <assert.h>

template <class T>
class Array {

	public:
		Array();
		Array(int capacity);
		Array(const Array& source);
		virtual ~Array();

	public:
		int Store(int index, T object);
		int AppendFromFront(T object);
		int AppendFromRear(T object);
		int Insert(int index, T object); 
		int	Delete(int index);
		int DeleteFromFront();
		int DeleteFromRear();
		int Modify(int index, T object);
		void Clear();
		void SelectionSort(int (*Compare)(void*, void*));
		int LinearSearchUnique(void* key, int (*Compare)(void*, void*));
		void LinearSearchDuplicate(void* key, int (*Compare)(void*, void*), int *count, int *(*resultSet));
		int BinarySearchUnique(void* key, int (*Compare)(void*, void*));
		void BinarySearchDupicate(void* key, int (*Compare)(void*, void*), int *count, int *(*resultSet));		
		void InsertionSort(int (*Compare)(void*, void*));
		void MergeSort(Array* firstArray, Array* secondArray, int (*Compare)(void*,void*));
		void Merge(Array* firstArray, Array* secondArray);
		
		bool IsEqual(const Array& other);
		bool IsNotEqual(const Array& other);
		bool operator ==(const Array& other);
		bool operator !=(const Array& other);
		
		Array& operator=(const Array& source);
		
		T* operator+(int index);
		T* operator-(int index);
		T* operator++(int);
		T* operator--(int);

		T& operator[](int index);
		int First();
		int Last();
		
		int GetCapacity() const;
		int GetLength() const;
		int GetCurrent() const;
		T* GetFront() const;

	private:
		T (*front);
		T (*rear);
		int capacity;
		int length;
		int current;
};

template <class T>
inline int Array<T>::GetCapacity() const
{
	return this->capacity;
}

template <class T>
inline int Array<T>::GetLength() const
{
	return this->length;
}

template <class T>
inline int Array<T>::GetCurrent() const
{
	return this->current;
}

template <class T>
inline T* Array<T>::GetFront() const
{
	return this->front;
}

template <class T>
Array<T>::Array()
{
	this->front = 0;
	this->rear = 0;
	this->capacity = 0;
	this->length = 0;
	this->current = -1;
}

template <class T>
Array<T>::Array(int capacity)
{
	this->front = new T[capacity];
	if(this->front != 0)
	{
		this->rear = (this->front) + capacity;
		this->capacity = capacity;
		this->length = 0;
		this->current = -1; //  ġ  ʾұ .(current ÷)
	}
}

template <class T>
Array<T>::Array(const Array& source)
{
	this->front = new T[source.capacity];
	if(this->front != 0)
	{
		for(int i=0; i<source.length; i++){
			this->front[i] = source.front[i];
		}

		this->rear = (this->front) + (source.capacity);
		this->capacity = source.capacity;
		this->length = source.length;
		this->current = source.current;
	}
}

template <class T>
Array<T>::~Array()
{
	if(this->front != 0)
	{
		delete[] this->front;
	}
	this->front = 0;
	this->rear = 0;
	this->current = -1;
	this->capacity = 0;
	this->length = 0;
}

template <class T>
Array<T>& Array<T>::operator=(const Array& source)
{
	if(this->front != 0)
	{
		delete[] this->front;
	}

	this->front = new T[source.capacity];

	if(this->front != 0)
	{

		for(int i=0; i<source.length; i++){
			this->front[i] = source.front[i];
		}

		this->rear = (this->front) + source.capacity;
		this->capacity = source.capacity;
		this->length = source.length;
		this->current = source.current;
	}
	return (*this); 
}

template <class T>
T& Array<T>::operator[](int index)
{
	return (this->front)[index];
}

template <class T>
int Array<T>::First()
{
	this->current = 0;
	return this->current;
}

template <class T>
int Array<T>::Last()
{
	this->current = this->capacity-1;
	return this->current;
}

template <class T>
int Array<T>::Store(int index, T object)
{
	this->current = index;
	if(this->current >= 0 && this->current < this->capacity)
	{
		this->front[this->current] = object; 
		(this->length)++;
	}
	else 
	{
		this->current = -1;
	}
	return this->current;
}

template <class T>
int Array<T>::Insert(int index, T object)
{
	T (*buffer) = 0;
	int i=0;
	
	this->current = index;
	
	assert(this->current >= 0 && this->current <= this->capacity); // <=   AppenFromRear ɵ ϱ ؼ
	
	buffer = new T[(this->capacity) + 1];

	while(i < this->current)
	{
		buffer[i] = this->front[i];
		i++;
	}
	while(i < this->length)
	{
		buffer[i+1] = this->front[i];
		i++;
	}

	delete[] this->front; 

	this->front = buffer; 
	(this->capacity)++;

	this->front[this->current] = object;
	(this->length)++;
	this->rear = (this->front) + (this->capacity); 

	return this->current;
}

template <class T>
int Array<T>::AppendFromFront(T object)
{
	T (*buffer) = 0;
	int i = 0;

	buffer = new T[this->capacity + 1];
	assert(buffer != 0);

	for(i=0; i <=this->length; i++)
	{
		buffer[i+1] = this->front[i];
	}
	
	assert(this->front != 0);
	delete[] this->front;

	this->front = buffer; // array->front buffer ġ Ű 
	(this->capacity)++;
	this->rear = this->front + this->capacity;

	this->current = 0;
	this->front[this->current] = object;
	(this->length)++;
	
	return this->current;
}

template <class T>
int Array<T>::AppendFromRear(T object)
{
	T (*buffer) = 0;
	int i = 0;

	buffer = new T[this->capacity + 1];
	assert(buffer != 0);

	for(i=0; i<this->length; i++)
	{
		buffer[i] = this->front[i];
	}
	
	assert(this->front != 0);
	delete[] this->front;

	this->front = buffer; // array->front buffer ġ Ű 
	(this->capacity)++;
	this->rear = this->front + this->capacity;

	this->current = this->length;
	this->front[this->current] = object;
	(this->length)++;
	
	return this->current;
}

template <class T>
int Array<T>::Delete(int index) 
{
	T (*buffer) = 0;
	int i=0;
	this->current = index;
	assert(this->current >=0 && this->current < this->capacity);

	if(this->front != 0)
	{
		if(this->capacity != 1) 
		{
			buffer = new T[this->capacity - 1];
			assert(buffer != 0);

			while(i < this->current)
			{
				buffer[i] = this->front[i];
				i++;
			}

			while(i < this->length)
			{
				buffer[i] = this->front[i+1];
				i++;
			}
		}
		delete[] this->front;
		this->front = buffer;
		(this->capacity)--;
		(this->length)--;
		
		if(this->front != 0)
		{
			this->rear = this->front + this->capacity;
		}
		else
		{
			this->rear = 0;
		}
		this->current = -1;
	}
	return this->current;
}

template <class T>
int Array<T>::DeleteFromFront()
{
	T (*buffer) = 0;
	int i=0;

	if(this->front != 0)
	{
		if(this->capacity != 1) 
		{
			buffer = new T[this->capacity - 1];
			assert(buffer != 0);
			while(i < this->length)
			{
				buffer[i] = this->front[i+1];
				i++;
			}
		}
		delete[] this->front;
		this->front = buffer;
		(this->capacity)--;
		(this->length)--;

		if(this->front != 0)
		{
			this->rear = this->front + this->capacity;
		}
		else
		{
			this->rear = 0;
		}

		this->current = -1;
	}
	return this->current;
}

template <class T>
int Array<T>::DeleteFromRear()
{
	T (*buffer) = 0;
	int i=0;

	if(this->front != 0)
	{
		if(this->capacity != 1) 
		{
			buffer = new T[(this->capacity) - 1];
			assert(buffer != 0);
			while(i < this->length-1)
			{
				buffer[i] = this->front[i];
				i++;
			}
		}
		delete[] this->front;
		this->front = buffer;
		(this->capacity)--;
		(this->length)--;

		if(this->front != 0)
		{
			this->rear = this->front + this->capacity;
		}
		else
		{
			this->rear = 0;
		}

		this->current = -1;
	}
	return this->current;
}

template <class T>
int Array<T>::Modify(int index, T object) 
{
	this->current = index;

	assert(this->current >= 0 && this->current < this->length);
	this->front[this->current] = object;

	return this->current;
}

template <class T>
void Array<T>::Clear()
{
	assert(this->front != 0);
	delete[] this->front;
	this->front = 0;
	this->rear = 0;
	this->capacity = 0;
	this->length = 0;
	this->current = -1;
}

template <class T>
int Array<T>::LinearSearchUnique(void *key, int (*Compare)(void*, void*)) // Լ !!
{
	int index = -1;
	this->current = 0;
	while(((this->current) < (this->length)) && Compare((char*)(this->front)+(this->current * sizeof(T)), key) != 0)
	{
		(this->current)++;
	}

	if(this->current < this->length)
	{
		index = this->current;
	}
	return index;
}

template <class T>
void Array<T>::LinearSearchDuplicate(void* key, int (*Compare)(void*, void*), int *count, int *(*resultSet))
{
	int i = 0;
	*count = 0;
	this->current = 0;
	while(this->current < this->length)
	{
		if((Compare((this->front)+(this->current), key)) == 0)
		{
			(*count)++;
		}
		(this->current)++;
	}
	if(*count > 0)
	{
		(*resultSet) = new int[*count];
		assert(*resultSet != 0);
		this->current = 0;
		while(this->current < this->length)
		{
			if(Compare(((char*)this->front)+((this->current) * sizeof(T)), key) == 0)
			{
				(*resultSet)[i] = this->current;
				i++;
			}
			(this->current)++;
		}
	}
}


template <class T>
int Array<T>::BinarySearchUnique(void *key, int (*Compare)(void*, void*)) // Լ !!
{
	int high;
	int low = 0;
	int mid;

	high = this->length-1;
	mid = (high+low)/2;
	while(low<=high && Compare((char*)(this->front) + (mid*sizeof(T)), key) != 0)
	{
		
		if(Compare(this->front+mid, key) < 0)
		{
			low = mid + 1;
		}
		else
		{
			high = mid - 1;
		}
		mid = (low+high)/2;
	}

	if(low<=high)
	{
		this->current = mid;
	}
	else
	{
		this->current = 0;
	}
	return this->current;
}

template <class T>
void Array<T>::BinarySearchDupicate(void* key, int (*Compare)(void*, void*), int *count, int *(*resultSet))
{
	int i=0;
	int high;
	int low = 0;
	int mid;
	*count = 0;

	high = (this->length)-1;
	mid = (high+low)/2;
	while(low<=high && Compare((char*)(this->front) + (mid*sizeof(T)), key) != 0){		
		if(Compare((this->front)+mid, key) < 0){
			low = mid + 1;
		}
		else{
			high = mid - 1;
		}
		mid = (low+high)/2;
	}

	if(low<=high){
		while(mid>0 && Compare(this->front + (mid-1), key) == 0){
			mid--;
		}
		
		this->current = mid;

		while(mid < this->length && Compare(this->front+mid, key) == 0){
			(*count)++;
			mid++;
		}
		*resultSet = new int[*count];
		while(i<*count){
			(*resultSet)[i] = this->current;
			this->current++;
			i++;
		}
	}
}

template <class T>
void Array<T>::SelectionSort(int (*Compare)(void*, void*))
{
	int i;
	int j;
	T min;
	int minindex;

	for(i=0; i<this->length-1; i++)
	{
		minindex = i;
		for(j=i+1; j<this->length; j++)
		{
			if(Compare((this->front + minindex), (this->front + j)) > 0)
			{
				minindex = j;
			}
		} //  iķ    ġ ã
		
		if(i != minindex) // ã ġ i  
		{
			min = this->front + minindex;
			this->front + minindex = this->front + i;
			this->front + i = min;
		}
	}
	assert(min != 0);
	delete min;
}

template <class T>
void Array<T>::InsertionSort(int (*Compare)(void*, void*))
{
	int i;
	T max;

	for(this->current = 1; this->current <this->length; (this->current)++)
	{
		max = this->front + this->current;
		i = this->current;

		while(i >= 1 && Compare(((char*)this->front) + ((i-1) * sizeof(T)), max) > 0)
		{
			this->front[i] = this->front[i-1];
			i--;
		}
		this->front[i] = max;
	}

	assert(max != 0);
	delete max;
}


template <class T>
void Array<T>::MergeSort(Array* firstArray, Array* secondArray, int (*Compare)(void*,void*))
{
	int i = 0;
	int j = 0;
	int k = 0;
	
	if(this->front != 0){
		delete[] this->front;
	}

	this->front = new T[firstArray->length + secondArray->length];

	assert(this->front != 0);	
	
	while(j < firstArray->length && k < secondArray->length)
	{
		if((Compare(firstArray->front+j, secondArray->front+k)) < 0)
		{
			
			this->front[i] = firstArray->front[j];
			i++;
			j++;
		}
		
		else
		{
			this->front[i] = secondArray->front[k];
			i++;
			k++;
		}
	}

	while(j < firstArray->length)
	{
		this->front[i]= firstArray->front[j];
		i++;
		j++;
	}

	while(k < firstArray->length)
	{
		this->front[i] = secondArray->front[k];
		i++;
		k++;
	}

	this->capacity = firstArray->length + secondArray->length;
	this->length = firstArray->length + secondArray->length;
	this->current = 0;
}

template <class T>
// Array<T>& Array<T>::Merge(Array* firstArray, Array* secondArray)
void Array<T>::Merge(Array* firstArray, Array* secondArray)
{
	int i;

	if(this->front != 0){
		delete[] this->front;
	}

	this->front = new T[firstArray->length + secondArray->length];
	for(i = 0; i<firstArray->length; i++)
	{
		this->front[i] = firstArray->front[i];
	}
	for(i = 0; i<secondArray->length; i++)
	{
		this->front[firstArray->length + i] = secondArray->front[i];
	}
	this->length = firstArray->length + secondArray->length;
	this->capacity = this->length;
	this->current = this->length;
}

template <class T>
bool Array<T>::IsEqual(const Array& other)
{
	bool ret = true;

	if(this->length == other.length){
		for(int i=0; i<other.length; i++){
			if(this->front[i] != other.front[i]){
				ret = false;
			}
		}
	}
	return ret;
}

template <class T>
bool Array<T>::IsNotEqual(const Array& other)
{
	bool ret = true;

	if(this->length == other.length){
		for(int i=0; i<other.length; i++){
			if(this->front[i] == other.front[i]){
				ret = false;
			}
		}
	}
	return ret;

}

template <class T>
bool Array<T>::operator ==(const Array& other)
{
	bool ret = true;

	if(this->length == other.length){
		for(int i=0; i<other.length; i++){
			if(this->front[i] != other.front[i]){
				ret = false;
			}
		}
	}

	return ret;
}

template <class T>
bool Array<T>::operator !=(const Array& other)
{
	bool ret = true;

	if(this->length == other.length){
		for(int i=0; i<other.length; i++){
			if(this->front[i] == other.front[i]){
				ret = false;
			}
		}
	}
	return ret;
}

template <class T>
T* Array<T>::operator+(int index)
{
	this->current = index;
	if(this->current >= this->capacity){
		this->current = this->capacity-1;
	}
	return (this->front+this->current);
}

template <class T>
T* Array<T>::operator-(int index)
{
	this->current = index;
	if(this->current < 0){
		this->current = 0;
	}
	return ((this->rear-1) - this->current);
}

template <class T>
T* Array<T>::operator++(int)
{
	if(this->current < this->capacity - 1){
		this->current++;
	}
	return (this->front+ this->current);
}

template <class T>
T* Array<T>::operator--(int)
{
	if(this->current > 0){
		this->current--;
	}
	return (this->front + this->current);
}

#endif // _ARRAY_H
